title memory procedures. coded by wbinvd

        include segments.inc

;------ Start of extrns ---------------------------------------
        extrn   GlobalAlloc:near,GlobalFree:near,GlobalReAlloc:near
;------ End of extrns -----------------------------------------

        public  new,resize,delete

        startcode
;Allocate bytes
;In:    EAX     size in bytes to allocate
;Out:   CF=0
;         EAX   address of block we allocated
;       CF=1
;         EAX   00000000h. Out of memory
;Regs:  EAX
AllocECXBytes:
        mov     eax,ecx
new             proc near
        push    ecx edx
        call    GlobalAlloc,00000000h,eax
        cmp     eax,00000001h
        pop     edx ecx
        retn
endp            new

;Delete the memory allocated through new:near
;In:    EAX     address of block
;Out:   CF=1    Could not delete it
;       CF=0    Deleted the block
;Regs:  EAX
delete          proc near
        push    ecx edx
        call    GlobalFree,eax
        cmp     eax,00000001h
        cmc
        pop     edx ecx
        retn
delete          endp

;Resize the memory block allcated through new:near or this procedure
;In:    EAX     address of block
;       ECX     new size in bytes
;Out:   CF=1
;         EAX   Unchanged. Not enough memory
;       CF=0
;         EAX   address of memory block
;Regs:  EAX,ECX
resize          proc near
        test    eax,eax                 ;Resize a NULL block?
        jz      short AllocECXBytes
        extrn   GlobalSize:near
        push    ecx edx
        xchg    ecx,eax                 ;EAX=Size in bytes,ECX=Address of block
        mov     edx,eax                 ;EDX=Size in bytes
        call    new
        jc      short @@CheckSmaller
        push    esi edi
        xchg    edi,eax                 ;EDI=new memory block
        mov     esi,ecx
        push    edx                     ;Save ESI's size
        call    GlobalSize,esi
        pop     edx
        cmp     eax,edx                 ;ESI's size < EDI's size?
        jb      short @@Yes
        xchg    edx,eax
@@Yes:
        xchg    ecx,eax
        mov     eax,edi
        rep movsb
        pop     edi esi
        clc
@@666:
        pop     edx ecx
        retn

;Since Windows 95 doesn't move the memory. If it can't resize more,
;it will just delete the memory, and return NULL.
;It would be nice if windows could really reallocate it, like the C func.
;GMEM_MOVEABLE flag only returns a handle, not an offset. Or am I wrong?
@@CheckSmaller:
        push    ecx edx
        call    GlobalSize,ecx
        pop     edx ecx
        cmp     edx,eax                 ;cmp WantedSize,CurrentSize
        jb      short @@666
        call    GlobalReAlloc,ecx,edx,00000000h
        clc
        jmp     short @@666
resize          endp
        endcode
        end
